/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.api.layout;

import dev.engine_room.flywheel.api.internal.FlwApiLink;
import dev.engine_room.flywheel.api.layout.FloatRepr;
import dev.engine_room.flywheel.api.layout.Layout;
import dev.engine_room.flywheel.api.layout.ValueRepr;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Range;

@ApiStatus.NonExtendable
public interface LayoutBuilder {
    public LayoutBuilder scalar(String var1, ValueRepr var2);

    public LayoutBuilder vector(String var1, ValueRepr var2, @Range(from=2L, to=4L) int var3);

    public LayoutBuilder matrix(String var1, FloatRepr var2, @Range(from=2L, to=4L) int var3, @Range(from=2L, to=4L) int var4);

    public LayoutBuilder matrix(String var1, FloatRepr var2, @Range(from=2L, to=4L) int var3);

    public LayoutBuilder scalarArray(String var1, ValueRepr var2, @Range(from=1L, to=256L) int var3);

    public LayoutBuilder vectorArray(String var1, ValueRepr var2, @Range(from=2L, to=4L) int var3, @Range(from=1L, to=256L) int var4);

    public LayoutBuilder matrixArray(String var1, FloatRepr var2, @Range(from=2L, to=4L) int var3, @Range(from=2L, to=4L) int var4, @Range(from=1L, to=256L) int var5);

    public LayoutBuilder matrixArray(String var1, FloatRepr var2, @Range(from=2L, to=4L) int var3, @Range(from=1L, to=256L) int var4);

    public Layout build();

    public static LayoutBuilder create() {
        return FlwApiLink.INSTANCE.createLayoutBuilder();
    }
}

